using System;
using System.Collections;
using System.Collections.Generic;
using Server;
using Server.Mobiles;
using Server.Gumps;
using Server.Network;
using Server.Factions;

namespace Server.Guilds
{
	public class GuildPerksGump : BaseGuildGump
	{
      public GuildPerksGump( PlayerMobile pm, Guild g ) : base( pm, g )
		{
			PopulateGump();
		}

		public override void PopulateGump()
		{
			base.PopulateGump();
			
			string html = "<basefont color=blue>AKTUALNI GUILDOVNI PERKY:<br><basefont color=black>";
			html += String.Format( "Min level 1 - Snizeni poplatku u hracskeho vendora: {0}/30%<br>", Math.Min( 30, guild.Level ) );
			html += String.Format( "Min level 1 - Bonus do maximalnich zivotu: +{0}/25<br>", Math.Min( 25, guild.Level ) );
			html += String.Format( "Min level 1 - Bonus do nosnosti postavy: +{0}/500 stones<br>", Math.Min( 500, guild.Level * 10 ) );
			html += String.Format( "Min level 1 - Sance na Guild Coins v pokladech z map: {0}/20%<br>", Math.Min( 20, guild.Level ) );
			html += String.Format( "Min level 1 - Sance na dvojite zvyseni skillu pri treninku: {0}/10%<br>", Math.Min( 10, guild.Level ) );
			html += String.Format( "Min level 1 - Sleva v dome barev: {0}/50%<br>", Math.Min( 50, guild.Level * 2 ) );
			html += String.Format( "Min level 1 - Vstup do dungeonu Pandemonium: -{0:F1}/4 dni<br>", (double) Math.Min( 20, guild.Level ) / 5.0 );
			html += String.Format( "Min level 1 - Sleva na pouziti bankovniho krystalu v dungeonech: {0}/25%<br>", Math.Min( 25, guild.Level ) );
			html += String.Format( "Min level 1 - Ziskavani fame a karmy: +{0}/20%<br>", Math.Min( 20, guild.Level ) );
			html += String.Format( "Min level 1 - Zvyseni sance na svitkovani,dratovani: +{0:F1}/5%<br>", Math.Min( 5.0, ( (double) guild.Level ) / 10.0 ) );
			html += String.Format( "Min level 1 - Bonus do zivotu na mape Underworld: +{0}/100<br>", Math.Min( 100, guild.Level / 2 ) );
			html += String.Format( "Min level 3 - Redukce damage z pasti: {0}/10%<br>", Math.Min( 10, (int) guild.Level / 3 ) );
			html += String.Format( "Min level 4 - Bonus do maximalni fyzicke resistence: +{0}/5<br>", Math.Min( 5, (int) guild.Level / 4 ) );
			html += String.Format( "Min level 5 - Sance na dvojitou exp. do levelovacich predmetu: {0}/10%<br>", ( guild.Level >= 5 ) ? Math.Min( 10, guild.Level ) : 0 );
			html += String.Format( "Min level 5 - Redukce damage z kritickych zasahu: -{0}/30%<br>", ( guild.Level >= 5 ) ? Math.Min( 30, guild.Level ) : 0 );
         html += String.Format( "Min level 10 - Kriticka damage z pekelneho parku: +{0}/25%<br>", ( guild.Level >= 10 ) ? Math.Min( 25, guild.Level ) : 0 );
			html += String.Format( "Min level 11 - Sleva na kouzlo Gift of Life: {0}/25%<br>", ( guild.Level > 10 ) ? Math.Min( 25, guild.Level - 10 ) : 0 );
			html += String.Format( "Min level 15 - Sacrifice self resurrection: +{0}/1<br>", ( guild.Level >= 15 ) ? 1 : 0 );
			
			html +=  "<br><basefont color=blue>SEZNAM PREDMETU NA GUILDOVNI PRISPEVKY:<br><basefont color=black>";

         List<Guild.RewardEntry> rw = Guild.Contribution();
        
         foreach ( Guild.RewardEntry re in rw )
            html += String.Format( "{0}: {1} Xp<br>", re.Name, re.RewardValue );
            
         html += "<br><basefont color=blue>OSTATNI MOZNOSTI ZISKANI EXPERIENCE:<basefont color=black><br>";
         html += "Nalezeny chromite: 20 - 50 Xp<br>";
         html += "Vykopani pokladu: 10 - 90 Xp za clena party<br>";
         html += "Vyloveni pokladu level 7+ z more: 100 - 300 Xp<br>";
         html += "Splneni Large bulk order: 20 - 200 Xp<br>";
         html += "Ziskani artefaktu z paragona nebo v Tokunu: 150 Xp<br>";
         html += "Ziskani artefaktu z wisp dungeon paragona: 350 Xp<br>";
         html += "Zabiti champion monstra: 50 - 1000 Xp za clena party<br>";
         html += "Splneni questu: 100 - 500 Xp<br>";
         html += "Ziskani artefaktu z teragona: 10000 Xp<br>";
         html += "Ziskani artefaktu z khaldunskeho teragona: 15000 Xp<br>";
         html += "Ziskani artefaktu z archeologie: 15000 Xp<br>";
         html += "Splneni ukolu od krale: 25000 Xp<br>";
         html += "Ziskani pokladu z dungeonu: xp dle obtiznosti (parta)<br>";
			
			AddHtml( 65, 83, 485, 320, html, true, true );
		}

		public override void OnResponse( NetState sender, RelayInfo info )
		{
			base.OnResponse( sender, info );
		}
	}
}